VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TrackerClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'////////////////////////////////////////////////////////////////////////
'//         Tracker Class  (VB side)                                   //
'////////////////////////////////////////////////////////////////////////
'
' The Tracker Class is meant to function as clearing house, "flex-point", and
' interface between the the C++ tracker code (C++ Tracker.ccp & various algorithms)
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Private mLRP As EchoGramClass
Private mHRP As EchoGramClass
Private mDP As DistributionPlotClass

Private mCollect As frmCollection

Private Const className = "TrackerClass(VB)"
Private Const OK = 0

Public Sub PrepareTracker()

  On Error GoTo oops:
  
  Dim rtv As Variant      ' return values comming from OCX _
                            - Need to be tested for errors!
  ' Alphabeta, JPDA, ...
  Dim alpha As Double     ' AlphaBeta, JPDA
  Dim beta As Double      ' AlphaBeta, JPDA
  
  ' Alphabeta (Only)
  Dim gate As Long        ' AlphaBeta (Only)
  
  ' JPDA (Only)
  Dim initGate As Double          ' JPDA (Only)
  Dim probOfDetect As Double      ' JPDA (Only)
  Dim extraneousDetect As Double  ' JPDA (Only)
  
  With general.trackerParameter
    Select Case .GetValue("tracker")
    
      Case ALPHABETA
        ' convert parameter strings to numerical values...
        alpha = Val(general.trackerParameter.GetValue("parameter1"))
        beta = Val(general.trackerParameter.GetValue("parameter2"))
        gate = Val(general.trackerParameter.GetValue("parameter3"))
        
        ' Check values and if they are OK, thene send them to the OCX
        If ValidateParamForAlphaBeta(alpha, beta, gate) Then
          With general.sonarIF
            rtv = .Tracker_ChangeTrackerState(ENABLE_ALPHABETA)
            If rtv <> OK Then Exit Sub
            rtv = .Tracker_SetParamAlphaBeta(alpha, beta, gate)
            If rtv <> OK Then Exit Sub
          End With
        End If
        
      Case JPDA
        ' convert parameter strings to numerical values...
        alpha = Val(general.trackerParameter.GetValue("parameter1"))
        beta = Val(general.trackerParameter.GetValue("parameter2"))
        initGate = Val(general.trackerParameter.GetValue("parameter3"))
        probOfDetect = Val(general.trackerParameter.GetValue("parameter4"))
        extraneousDetect = Val(general.trackerParameter.GetValue("parameter5"))
        
        ' Check values and if they are OK, send them to the OCX
        If ValidateParamForJPDA(alpha, beta, initGate, probOfDetect, extraneousDetect) Then
          With general.sonarIF
            rtv = .Tracker_ChangeTrackerState(ENABLE_JPDA)
            If rtv <> OK Then Exit Sub
            rtv = .Tracker_SetParamJPDA(alpha, beta, initGate, probOfDetect, extraneousDetect)
            If rtv <> OK Then Exit Sub
          End With
        End If

      ' Case ???  - Add here for each additional algorithms
      
      Case Else
        Debug.Assert (False)
        MsgBox "The chosen algorithm (algorithm = " & _
                  (.GetValue("tracker")) & ") has not been implemented."
        general.propertyList.SetProperty "General:Tracker_Active", False
    End Select
  End With
       
  mCollect.SetCaption mCollect.caption & " -- Tracking"
  PrepareEchogramDisplays ' Setup Displays
  
  Exit Sub
  
oops:
  ErrorBox
  SuspendTrackingInOCX
  
End Sub

Public Sub SuspendTrackingInOCX()

  On Error GoTo oops:
  
  rtv = general.sonarIF.Tracker_ChangeTrackerState(SUSPEND_TRACKING)
  ' may want to check return value...
  general.propertyList.SetProperty "General:Tracker_Active", False
  mCollect.caption = mCollect.caption & " - Tracking Suspended"
  mCollect.trackerMnuConfig
  
  Exit Sub
  
oops:
  StoreError
  
End Sub

Public Sub SuspendTrackingInUI()

  On Error GoTo oops:
  
  mHRP.Set_mShowTracks False
  mLRP.Set_mShowTracks False
  mDP.SetTrackingOptions echoesInHRP

  general.propertyList.SetProperty "General:Tracker_Active", False
  
  Exit Sub
  
oops:
  StoreError
  
End Sub

Public Sub SuspendTracking()

  On Error GoTo oops:
  
  SuspendTrackingInUI
  SuspendTrackingInOCX
  
  Exit Sub
  
oops:
  StoreError
  
End Sub
Public Function IsTracking() As Boolean

  On Error GoTo oops:
  
  IsTracking = general.propertyList.GetProperty("General:Tracker_Active", False)

  Exit Function
  
oops:
  StoreError
  
End Function

Private Sub PrepareEchogramDisplays()

  On Error GoTo oops:
  
  Dim rtv_LRP As String
  Dim rtv_HRP As String
  Dim prompt As String
  
  rtv_LRP = mLRP.CheckPixelSizeAtStart
  rtv_HRP = mHRP.CheckPixelSizeAtStart
  
  prompt = IIf(rtv_LRP <> "", vbCrLf & "Please check settings for the LRP:" & vbCrLf & rtv_LRP, "") _
         & IIf(rtv_HRP <> "", vbCrLf & "Please check settings for the HRP:" & vbCrLf & rtv_HRP, "")
         
  If rtv_LRP <> "" Or rtv_HRP <> "" Then
    prompt = prompt & vbCrLf & vbCrLf & " You you wish to increase the echo point size, or would you rather cancel?"
    reply = MsgBox(prompt, vbYesNoCancel, "Larger Echo Size Needed: 3 x 3 pixels mimimum.")
    Select Case reply
      Case vbNo         ' do nothing - display w/ bad sizes
      Case vbYes        ' fix sizes
        mLRP.SetMinEchoSize 3, 3
        mHRP.SetMinEchoSize 3, 3
      Case vbCancel
        If rtv_LRP <> "" Then mLRP.Set_mShowTracks False
        If rtv_HRP <> "" Then mHRP.Set_mShowTracks False
      Case Else
        Debug.Assert False
    End Select
  End If

  Exit Sub
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & "PrepareEchogramDisplays"
  
End Sub

Public Function GetCountByClass(minRange As Double, maxRange As Double, Class As Integer, _
                                    earliestStart As Integer, latestEnd As Integer) As Long
  On Error GoTo oops:
  
  GetCountByClass = general.sonarIF.Tracker_GetCountByClass(minRange, _
                                  maxRange, (Class), (earliestStart), (latestEnd))
  Exit Function

oops:
  StoreError
  GetCountByClass = 0
  
End Function

Public Function GetCountTracksByTS(minRange As Double, maxRange As Double, minTS As Double, _
                                    maxTS As Double, earliestStart As Long, latestEnd As Long) As Long
  On Error GoTo oops:
  
  GetCountTracksByTS = general.sonarIF.Tracker_GetCountTracksByTS(minRange, _
                                   maxRange, minTS, maxTS, (earliestStart), (latestEnd))
  Exit Function

oops:
  StoreError
  GetCountTracksByTS = 0
  
End Function

Private Function ValidateParamForAlphaBeta(alpha As Double, beta As Double, _
                                          gate As Long) As Boolean
  
  On Error GoTo oops:
  
  ValidateParamForAlphaBeta = False
  
  Dim OK As Boolean
  
  OK = True
  
  If Not IsBetween(alpha, 0, 1, exclusive:=False) Then OK = False
  If Not IsBetween(beta, 0, 1, exclusive:=False) Then OK = False
  If Not IsBetween(gate, 0, 401) Then OK = False

  ValidateParamForAlphaBeta = True
  
  Exit Function
  
oops:
  ErrorBox
  ValidateParamForAlphaBeta = False
  
End Function

Private Function ValidateParamForJPDA(alpha As Double, beta As Double, _
                                      initGate As Double, probOfDetect As Double, _
                                      extraneousDetect As Double) As Boolean
  ' checks parameter values for an alpha beta tracker to make sure that they are reasonble/legal
  
  On Error GoTo oops:
  VValidateParamForJPDA = False
  
  Dim OK As Boolean
  
  OK = True
  
  If Not IsBetween(alpha, 0, 1, exclusive:=False) Then OK = False
  If Not IsBetween(beta, 0, 1, exclusive:=False) Then OK = False
  If Not IsBetween(initGate, 0, 401) Then OK = False
  If Not IsBetween(probOfDetect, 0, 1, exclusive:=False) Then OK = False
  If Not IsBetween(extraneousDetect, 0, 1, exclusive:=False) Then OK = False
  
  ValidateParamForJPDA = OK
  
  Exit Function
  
oops:
  ErrorBox
  ValidateParamForJPDA = False
  
End Function

Public Sub PingingStop()

  On Error GoTo oops:
  
  If IsStoredTracks Then Exit Sub ' no point in recording what has already been recorded
  
  Dim reply As Integer
  reply = MsgBox("Do you wish to be able replay track information?", vbQuestion + vbYesNo, _
                "Record Track Information")
                
  If reply = vbYes Then SaveTrackSeries
  ' there may be other thing in the future that the tracker needs to do when pinging stops...
  
  Exit Sub
  
oops:
  ErrorBox
  
End Sub

Private Sub SaveTrackSeries()

  On Error GoTo oops:
  
  Dim prompt As String
  Dim db As DbConnectionClass
  Dim newTrackSeries As New GeneralConfigurationClass
  
  Set db = general.pingDB   ' get the right database
  
  isVerbose = False     ' supresses message boxes while creating tables
  ' fetch the default copy of the track series - if there isn't a TS table _
    and/or default record the gen. config. class will create one
  newTrackSeries.SetConfigType trackSeriesTC
  newTrackSeries.ReadFromDB dbToUse:=db, name:="default"
    
  ' enter the information that I do know - or some default value if I don't know it yet
  newTrackSeries.SetValue "trackSeriesID", GenerateUniqueID
  newTrackSeries.SetValue "pingSeriesID", general.sonarIF.GetPingSeriesID
  newTrackSeries.SetValue "processedBy", "unknown"
  newTrackSeries.SetValue "creationDate", Date
  newTrackSeries.SetValue "softwareVersion", GetSoftwareVersion
  newTrackSeries.SetValue "name", "none given"
  newTrackSeries.SetValue "trackerConfigurationID", _
                           general.trackerParameter.GetValue("trackerConfigurationID")
  
  ' request the information that I don't know from the user.
  If GetAdditionalInfo(newTrackSeries) = False Then Exit Sub ' [user can cancel at this point]
  
  db.BeginTrans
  
  If Not newTrackSeries.SaveToDB(dbToUse:=db, addDate:=False) Then
    Err.Clear
    Err.Raise SAVE_ERROR, className & "SaveTrackSeries", _
                          MyStoredError.DescriptionOfError(SAVE_ERROR)
  End If
  
  ' NOTE - if the tables are not already present, then by attempting to read them, _
                                                      I will cause them to be created
  Dim dummy As New GeneralConfigurationClass
  dummy.SetConfigType trackParametersTC
  dummy.ReadFromDB dbToUse:=db, name:="default"
  
  If 0 = general.trackerParameter.DuplicateCount(dbToUse:=db, _
            withID:=general.trackerParameter.GetValue("trackerConfigurationID")) Then
    If Not general.trackerParameter.SaveToDB(dbToUse:=db, addDate:=False) Then
      ' If I can't save the parameters, then I need to back out.
      '   Remove the trackseries record that I just created and then inform the user
      prompt = "Was unable to save tracker parameters. (Sorry.)"
      MsgBox prompt, , "Couldn't Save Track Settings:"
      db.RollbackTrans
      isVerbose = True
      Exit Sub
    Else
      ' Do nothing - it worked.
    End If
  End If
  db.CommitTrans
  
  isVerbose = True
  Exit Sub
  
oops:
  ErrorBox
  db.RollbackTrans
  isVerbose = True
  
End Sub

Private Function GetAdditionalInfo(newTrackSeries As GeneralConfigurationClass) As Boolean

  On Error GoTo oops:
  
  Dim reply As String
  reply = InputBox("Please enter a name for the new 'Track Series':", _
                                "Enter Track Series Name:", GenerateUniqueID)
  newTrackSeries.SetValue "name", Left(reply, 49)
  
  reply = InputBox("Please enter your name:", "Enter Your Name:", "Anon.")
  newTrackSeries.SetValue "processedBy", Left(reply, 49)
  
  GetAdditionalInfo = True
  
  Exit Function
oops:
  ErrorBox
  GoTo oops2:
  Resume Next
  
  Exit Function

oops2:
  ErrorBox
  GetAdditionalInfo = False
  
End Function

Public Sub Set_mLRP(gram As EchoGramClass)
  
  Set mLRP = gram
  
End Sub

Public Sub Set_mHRP(gram As EchoGramClass)

  Set mHRP = gram
  
End Sub

Public Sub Set_mDP(gram As DistributionPlotClass)

  Set mDP = gram
  
End Sub

Public Sub Set_mCollect(collectionForm As frmCollection)

  Set mCollect = collectionForm
  
End Sub
